/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class DiagramNavigation
extends Applet {
    public JSObject appletWindow;
    public Hashtable images = new Hashtable();
    public Image myImage = null;
    public int myWidth = 0;
    public int myHeight = 0;
    public int maxWidth = 1;
    public int maxHeight = 1;
    public int imgW = 0;
    public int imgH = 0;
    public double rate = 1.0;
    public int xs = 0;
    public int ys = 0;
    public Rectangle spotRect = new Rectangle();
    public Point dragPoint = new Point();
    public boolean onSpot = false;
    public boolean isDragged = false;

    public void init() {
        this.setBackground(Color.white);
        try {
            this.appletWindow = JSObject.getWindow((Applet)this);
        }
        catch (JSException jSException) {
            // empty catch block
        }
        this.maxWidth = this.getSize().width - 2;
        this.maxHeight = this.getSize().height - 2;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.onSpot) {
                    DiagramNavigation.this.dragPoint = mouseEvent.getPoint();
                    DiagramNavigation.this.xs = ((DiagramNavigation)DiagramNavigation.this).dragPoint.x - ((DiagramNavigation)DiagramNavigation.this).spotRect.x;
                    DiagramNavigation.this.ys = ((DiagramNavigation)DiagramNavigation.this).dragPoint.y - ((DiagramNavigation)DiagramNavigation.this).spotRect.y;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DiagramNavigation.this.isDragged = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.spotRect.contains(mouseEvent.getPoint())) {
                    DiagramNavigation.this.setCursor(new Cursor(13));
                    DiagramNavigation.this.onSpot = true;
                } else {
                    DiagramNavigation.this.setCursor(new Cursor(0));
                    DiagramNavigation.this.onSpot = false;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.onSpot) {
                    DiagramNavigation.this.isDragged = true;
                    Graphics graphics = DiagramNavigation.this.getGraphics();
                    graphics.setXORMode(Color.white);
                    DiagramNavigation.this.drawSpot(graphics);
                    DiagramNavigation.this.dragPoint = mouseEvent.getPoint();
                    DiagramNavigation.this.setSpotLocation(mouseEvent.getX() - DiagramNavigation.this.xs, mouseEvent.getY() - DiagramNavigation.this.ys);
                    DiagramNavigation.this.drawSpot(graphics);
                    graphics.dispose();
                    try {
                        if (DiagramNavigation.this.appletWindow != null) {
                            DiagramNavigation.this.appletWindow.eval("parent.imageFrame.scroll(" + String.valueOf((double)Math.round((double)((DiagramNavigation)DiagramNavigation.this).spotRect.x - 1.0) * DiagramNavigation.this.rate) + ", " + String.valueOf((double)Math.round((double)((DiagramNavigation)DiagramNavigation.this).spotRect.y - 1.0) * DiagramNavigation.this.rate) + ")");
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.appletWindow.eval("parent.imageFrame.loadImage()");
    }

    public void paint(Graphics graphics) {
        graphics.setPaintMode();
        if (this.myImage != null) {
            graphics.drawImage(this.myImage, 1, 1, this.myWidth, this.myHeight, this);
        }
        this.drawSpot(graphics);
        graphics.setColor(Color.blue);
        graphics.drawRect(0, 0, this.myWidth + 2, this.myHeight + 2);
    }

    private void drawSpot(Graphics graphics) {
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        graphics.fillRect(this.spotRect.x, this.spotRect.y, this.spotRect.width, this.spotRect.height);
    }

    public void loadView(String string, int n2, int n3) {
        if (this.images.containsKey(string)) {
            ImageInfo imageInfo = (ImageInfo)this.images.get(string);
            this.myImage = imageInfo.getImage();
            this.myWidth = imageInfo.getWidth();
            this.myHeight = imageInfo.getHeight();
            this.rate = imageInfo.getRate();
            this.imgW = imageInfo.getImageWidth();
            this.imgH = imageInfo.getImageHeight();
        } else {
            Object object;
            try {
                double d2;
                object = this.getImage(this.getDocumentBase(), string);
                if (object == null) {
                    return;
                }
                this.imgW = n2;
                this.imgH = n3;
                double d3 = (double)this.imgW / (double)this.maxWidth;
                if (d3 < 1.0) {
                    d3 = 1.0;
                }
                if ((d2 = (double)this.imgH / (double)this.maxHeight) < 1.0) {
                    d2 = 1.0;
                }
                this.rate = Math.max(d3, d2);
                this.myHeight = (int)Math.round((double)this.imgH / this.rate) - 1;
                this.myWidth = (int)Math.round((double)this.imgW / this.rate) - 1;
                this.myImage = ((Image)object).getScaledInstance(this.myWidth, this.myHeight, 4);
                ((Image)object).flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            if (this.myHeight > 1 && this.myWidth > 1) {
                object = new ImageInfo(this.myImage, this.myWidth, this.myHeight, this.rate, this.imgW, this.imgH);
                this.images.put(string, object);
            }
        }
    }

    public void setSpotSize(int n2, int n3) {
        double d2 = (double)this.imgW / (double)n2;
        double d3 = (double)this.imgH / (double)n3;
        int n4 = (int)Math.round((double)this.myWidth / d2);
        int n5 = (int)Math.round((double)this.myHeight / d3);
        n4 = Math.min(n4, this.myWidth);
        n5 = Math.min(n5, this.myHeight);
        if (n4 <= 1) {
            n4 = 1;
        }
        if (n5 <= 1) {
            n5 = 1;
        }
        this.spotRect.setSize(n4, n5);
        int n6 = this.myWidth + 2 - this.spotRect.x - this.spotRect.width;
        int n7 = this.myHeight + 2 - this.spotRect.y - this.spotRect.height;
        if (n6 >= 0) {
            n6 = 0;
        }
        if (n7 >= 0) {
            n7 = 0;
        }
        if (n6 < 0 || n7 < 0) {
            this.moveSpotRelative(n6, n7);
        }
    }

    public void moveSpot(int n2, int n3) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n4 = (int)Math.round((double)n2 / this.rate) + 1;
            int n5 = (int)Math.round((double)n3 / this.rate) + 1;
            this.setSpotLocation(n4, n5);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void moveSpotRelative(int n2, int n3) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n4 = this.spotRect.x + n2;
            int n5 = this.spotRect.y + n3;
            this.setSpotLocation(n4, n5);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void setSpotLocation(int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        if (n2 < 1) {
            n4 = 1;
        } else if (n2 + this.spotRect.width > this.myWidth + 2) {
            n4 = this.myWidth + 2 - this.spotRect.width;
        }
        if (n3 < 1) {
            n5 = 1;
        } else if (n3 + this.spotRect.height > this.myHeight + 2) {
            n5 = this.myHeight + 2 - this.spotRect.height;
        }
        this.spotRect.setLocation(n4, n5);
    }

    private class ImageInfo {
        public int width = 0;
        public int height = 0;
        public int imgW = 0;
        public int imgH = 0;
        public Image image = null;
        public double rate = 1.0;

        public ImageInfo(Image image, int n2, int n3, double d2, int n4, int n5) {
            this.image = image;
            this.width = n2;
            this.height = n3;
            this.rate = d2;
            this.imgW = n4;
            this.imgH = n5;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public double getRate() {
            return this.rate;
        }

        public Image getImage() {
            return this.image;
        }

        public int getImageWidth() {
            return this.imgW;
        }

        public int getImageHeight() {
            return this.imgH;
        }
    }
}

