/**
 * This script invokes the tests specified in the associated
 * suite table <code>Data/suite.xls</code>. We call it "kickoff"
 * because all it does is to call the generic test suite driver with a
 * few parameters.
 * <p>
 * By default this suite processes the suite table whose name is hard-coded 
 * in the script (you must read the code to find it out). This is desirable
 * because production suite tables should be kept stable and under 
 * version control (i.e. read-only). Such tables should define 
 * <b>the complete</b> set of tests for the particular test purpose. 
 * <p>
 * However, during development of the test suite or in a 
 * multi-user environment it is often needed to execute only 
 * parts of the whole test suite. One could do this by enbling/disabling 
 * rows in the production suite table. This shall soon prove inconvenient
 * and cumbersome. Moreover, it corrupts the afore mentioned stability of
 * production test suites.
 * <p>
 * A better way to cope with this problem is by creating small 
 * private suite tables and by redirect the kickoff-script to 
 * these tables instead of the default one. 
 * <p>
 * You can do this by allocating the environment variable called
 * <code>MY_SUITE</code> and assiging the appropriate
 * value to it (the name of your suite table relative
 * to the DATA_HOME directory, e.g. "mysuite.xls"). 
 * Remember to remove this variable when you are ready to 
 * execute the default suite. 
 
 @stereotype main test
 @tsl <A HREF= "kickoff.tsl">kickoff.tsl</A>
*/

public class kickoff
{
}
