package lib;

/**
 * This library contains generic Framework-related functions. 
 * "Generic" means that they are likely to be used in all contexts.
 
 @stereotype compiled module
 @tsl <A HREF= "FRM_lib.tsl">FRM_lib.tsl</A>
*/

public class FRM_lib
{
/**
 * Ensures the initial state of the application. This function is the backbone of the
 * robustness startegy for the whole test suite. It will close all unwanted windows if necesary. 
 * It will (re)invoke the AUT if necessary and perform the login. By the exit of this function
 * we can assume that the main application window is displayed. This is the starting point
 * for all tests.
 *
 * @see <a href="../../images/AUT/FRM_Prolog.jpg">GUI</a>
 * @see <a href="../../images/AUT/FRM_Prolog_block.jpg">Excel</a>
 */

public int FRM_Prolog( in table, in test, in idx, in mode ) {};

/**
 * This is the short version of Prolog() with the difference that it does not attempt 
 * to log in. It ensures that the Login window is open instead of the main AUT window. 
 * This was done so that we can test the login dialog on its own.
 *
 * @see <a href="../../images/AUT/FRM_Prolog2_block.jpg">Excel</a>
 */

public int FRM_Prolog2( in table, in test, in idx, in mode ) {};

/**
 * @see <a href="../../images/AUT/FRM_Login.jpg">GUI</a>
 * @see <a href="../../images/AUT/FRM_Login_block.jpg">Excel</a>
 */

public int FRM_Login( in table, in test, in idx, in mode ) {};

/**
 * Provides the possibility to chose an item from the main menu and toolbar. 
 *
 * @see <a href="../../images/AUT/FRM_Main.jpg">GUI</a>
 * @see <a href="../../images/AUT/FRM_Main_block.jpg">Excel</a>
 */

public int FRM_Main( in table, in test, in idx, in mode ) {};

/**
 * Handles the dynamic popup message dialog. The tester can define three deisions: whether
 * the dialog was expected or not, what message should be desplayed and what button to
 * use to close the dialog. Different types of message dialogs are handled with the same
 * function, e.g. OK, Yes/No, OK/Cancel. You have to make sure that the GUI-map is 
 * propeprly configured (not a trivial task).
 */

public int FRM_PopUp_Message( in table, in test, in idx, in mode ) {};

/**
 * Handles the pop-up message dialog. It reads up to three lines fom the data
 * table and checks whether the dialog popped up and whether the expected
 * message matches (i.e. regular expresion) the given string. It also handles
 * situations when message window is not expected.
 * @param table (in)	index of the data table
 * @param test (in)		test
 * @param window (in)	logical name of the popup window
 * @param timeout (in)	timeout in seconds to wait for popup window
 */

private int FRM_CheckPopUpMessage( in table, in test, in window, in timeout ) {};

private int process_expected_popup_win( in table, in test, in window, in timeout ) {};

private int process_unexpected_popup_win( in table, in test, in window, in timeout ) {};

private int ignore_popup_win( in table, in test, in window, in timeout ) {};

}
