package lib;

/**
 * This library contains function specially designed fro processing table
 * objects. In this respect this library extends the funtionallity of the
 * standard emos_frm_gui_lib.
 * <p>NOTE<br>
 * These functions obey the rules of EMOS Framework (i.e. error logging,
 * error processing, FRM modes, etc.). To understand these concepts
 * you should study and understand emos_frm_gui_lib before you attempt
 * to add your own logic. 
 * @author drajovic
 
 @stereotype compiled module
 @tsl <A HREF= "FRM_TBL_lib.tsl">FRM_TBL_lib.tsl</A>
*/

public class FRM_TBL_lib
{
/**
 * Performs table action(s) on a 1-dimensional block of table cells.
 *
 * @param tid	(in)	id of the table where the instructins come from
 * @param test	(in)	name of the test to run (as named in column "Name")
 * @param obj	(in)	table object where actions are to be performed
 * @param desc (in) [optional] phisical descr. of the object contained in the table cell
 * @param desc (in) [optional] phisical descr. of the list element of the combo box
 * @return E_OK if success, else error
 */

public int FRM_TBL_set_data( in tid, in test, in obj, in desc, in list ) {};

/**
 * Performs table action(s) on a 2-dimensional block of table cells.
 *
 * @param tid	(in)	id of the table where the instructins come from
 * @param test	(in)	name of the test to run (as named in column "Name")
 * @param obj	(in)	table object where actions are to be performed
 * @return E_OK if success, else error
 */

public int FRM_TBL_set_data_block( in tid, in test, in obj ) {};

}
