package lib;

/**
 * This library contains generic Framework-related functions. 
 * "Generic" means that they are likely to be used in all contexts.
 
 @stereotype compiled module
 @tsl <A HREF= "FRM_lib.tsl">FRM_lib.tsl</A>
*/

public class FRM_lib
{
/**
 * This is the short version of Prolog() with the difference that it does not attempt 
 * to log in. It ensures that the Login window is open instead of the main AUT window. 
 * This was done so that we can test the login dialog on its own.
 *
 * @see <a href="../../images/Prolog.jpg">GUI</a>
 * @see <a href="../../images/Prolog_block.jpg">Excel</a>
 */

public int FRM_Prolog( in table, in test, in idx, in mode ) {};

/**
 * @see <a href="../../images/Login.jpg">GUI</a>
 * @see <a href="../../images/Login_block.jpg">Excel</a>
 */

public int FRM_Login( in table, in test, in idx, inout mode ) {};

/**
 * Provides the possibility to click on up to two images.
 * You may want to add clicks to links as well (makes sense for many AUTs).
 *
 * @see <a href="../../images/Main.jpg">GUI</a>
 * @see <a href="../../images/Main_block.jpg">Excel</a>
 */

public int FRM_Main( in table, in test, in idx, in mode ) {};

/**
 * Provides the possibility to click on three images/buttons on left-side
 * navigation bar.
 * Note how we have solved the problem of having to click on same images
 * within different frames. We have replaced the inital set_window()
 * with web_sync() and included phisical properties instead of the logical names.
 *
 * @see <a href="../../images/Navbar.jpg">GUI</a>
 * @see <a href="../../images/Navbar_block.jpg">Excel</a>
 */

public int FRM_Navbar( in table, in test, in idx, inout mode ) {};

/**
 * Handles the dynamic popup message dialog. The tester can define three deisions: whether
 * the dialog was expected or not, what message should be desplayed and what button to
 * use to close the dialog. Different types of message dialogs are handled with the same
 * function, e.g. OK, Yes/No, OK/Cancel. You have to make sure that the GUI-map is 
 * propeprly configured (not a trivial task).
 */

public int FRM_PopUp_Message( in table, in test, in idx, in mode ) {};

/**
 * Handles the pop-up message dialog. It reads up to three lines fom the data
 * table and checks whether the dialog popped up and whether the expected
 * message matches (i.e. regular expresion) the given string. It also handles
 * situations when message window is not expected.
 * @param table (in)	index of the data table
 * @param test (in)		test
 * @param window (in)	logical name of the popup window
 * @param timeout (in)	timeout in seconds to wait for popup window
 */

private int FRM_CheckPopUpMessage( in table, in test, in window, in timeout ) {};

private int process_expected_popup_win( in table, in test, in window, in timeout ) {};

private int process_unexpected_popup_win( in table, in test, in window, in timeout ) {};

private int ignore_popup_win( in table, in test, in window, in timeout ) {};

}
